<?php
// markets.php — live from Binance (spot + futures)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Methods: GET, OPTIONS");
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(200); exit; }
header('Content-Type: application/json; charset=utf-8');

function fetch_json($url){
  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CONNECTTIMEOUT => 8,
    CURLOPT_TIMEOUT => 12,
    CURLOPT_SSL_VERIFYPEER => true,
    CURLOPT_SSL_VERIFYHOST => 2,
    CURLOPT_USERAGENT => 'Quantum/1.0'
  ]);
  $out = curl_exec($ch);
  if ($out === false) {
    $err = curl_error($ch);
    curl_close($ch);
    throw new Exception("CURL_FAIL: $err");
  }
  $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);
  if ($code !== 200) throw new Exception("HTTP_$code");
  return json_decode($out, true);
}

// 10 spot + 10 futures
$spot = ['BTCUSDT','ETHUSDT','SOLUSDT','BNBUSDT','XRPUSDT','DOGEUSDT','ADAUSDT','TONUSDT','TRXUSDT','AVAXUSDT'];
$futs = ['BTCUSDT','ETHUSDT','SOLUSDT','BNBUSDT','XRPUSDT','DOGEUSDT','ADAUSDT','TONUSDT','TRXUSDT','AVAXUSDT'];

// fetch both endpoints (24hr ticker)
try {
  $spotQ = urlencode(json_encode($spot));
  $futQ  = urlencode(json_encode($futs));

  $spotData = fetch_json("https://api.binance.com/api/v3/ticker/24hr?symbols={$spotQ}");
  $futData  = fetch_json("https://fapi.binance.com/fapi/v1/ticker/24hr?symbols={$futQ}");

  // leverage map for futures display
  $lev = ['BTC'=>125,'ETH'=>75,'SOL'=>50,'BNB'=>50,'XRP'=>50,'DOGE'=>50,'ADA'=>50,'TON'=>25,'TRX'=>50,'AVAX'=>50];

  $out = [];

  foreach ($spotData as $t) {
    $sym = $t['symbol']; // e.g. BTCUSDT
    $base = str_replace('USDT','',$sym);
    $out[] = [
      'symbol'   => $base.'/USDT',
      'base'     => $base,
      'price'    => (float)$t['lastPrice'],
      'change24' => (float)$t['priceChangePercent'],
      'type'     => 'spot',
      'leverage' => null,
    ];
  }

  foreach ($futData as $t) {
    $sym = $t['symbol'];
    $base = str_replace('USDT','',$sym);
    $out[] = [
      'symbol'   => $base.'/USDT',
      'base'     => $base,
      'price'    => (float)$t['lastPrice'],
      'change24' => (float)$t['priceChangePercent'],
      'type'     => 'futures',
      'leverage' => $lev[$base] ?? 50,
    ];
  }

  echo json_encode(['ok'=>true,'data'=>$out]);
} catch (Throwable $e) {
  echo json_encode(['ok'=>false, 'error'=>'BINANCE_FETCH_FAIL', 'detail'=>$e->getMessage()]);
}
