<?php
require __DIR__.'/config.php'; json();

/* Required: email, password, country, captchaAnswer, captchaEcho
   Optional: phone, referral */
$in = json_decode(file_get_contents('php://input'), true) ?? [];
$missing = required($in,['email','password','country','captchaAnswer','captchaEcho']);
if ($missing){ echo json_encode(['ok'=>false,'error'=>'MISSING_'.$missing]); exit; }

$email   = strtolower(trim($in['email']));
$phone   = trim($in['phone'] ?? '');
$country = trim($in['country']);
$pass    = (string)$in['password'];
$refIn   = trim($in['referral'] ?? '');

if (!filter_var($email, FILTER_VALIDATE_EMAIL)){ echo json_encode(['ok'=>false,'error'=>'INVALID_EMAIL']); exit; }
if (strlen($pass) < 8){ echo json_encode(['ok'=>false,'error'=>'WEAK_PASSWORD']); exit; }

/* CAPTCHA verify (simple math) */
$echo = json_decode(base64_decode($in['captchaEcho']), true);
if (!$echo || !isset($echo['a'],$echo['b'])){ echo json_encode(['ok'=>false,'error'=>'CAPTCHA_TAMPERED']); exit; }
$correct = intval($echo['a']) + intval($echo['b']);
if (intval($in['captchaAnswer']) !== $correct){ echo json_encode(['ok'=>false,'error'=>'CAPTCHA_FAIL']); exit; }

$conn = db();

/* Email / phone existence (for smooth popups in app) */
$st = $conn->prepare("SELECT uid FROM users WHERE email=? LIMIT 1");
$st->bind_param('s',$email); $st->execute(); $st->store_result();
if ($st->num_rows > 0) { echo json_encode(['ok'=>false,'error'=>'EMAIL_EXISTS']); exit; }
$st->close();

if ($phone !== '') {
  $st = $conn->prepare("SELECT uid FROM users WHERE phone=? LIMIT 1");
  $st->bind_param('s',$phone); $st->execute(); $st->store_result();
  if ($st->num_rows > 0) { echo json_encode(['ok'=>false,'error'=>'PHONE_EXISTS']); exit; }
  $st->close();
}

/* Validate referral (optional) */
$referredBy = null;
if ($refIn !== ''){
  $v = $conn->prepare("SELECT referral_code FROM users WHERE referral_code=?");
  $v->bind_param('s',$refIn); $v->execute(); $v->store_result();
  if ($v->num_rows === 0){ echo json_encode(['ok'=>false,'error'=>'BAD_REFERRAL']); exit; }
  $referredBy = $refIn; $v->close();
}

/* Unique uid + referral_code */
$uid = make_uid_unique($conn);
if(!$uid){ echo json_encode(['ok'=>false,'error'=>'UID_GEN_FAIL']); exit; }

$myRef = make_ref_unique($conn);
if(!$myRef){ echo json_encode(['ok'=>false,'error'=>'REF_GEN_FAIL']); exit; }

$hash = password_hash($pass, PASSWORD_DEFAULT);

/* Insert */
$ins = $conn->prepare("INSERT INTO users (uid, email, phone, country, password_hash, referral_code, referred_by)
VALUES (?,?,?,?,?,?,?)");
$ins->bind_param('sssssss', $uid, $email, $phone, $country, $hash, $myRef, $referredBy);
if(!$ins->execute()){
  // If rare collision slipped through
  $err = ($conn->errno===1062)?'DUPLICATE_KEY':'DB_ERROR';
  echo json_encode(['ok'=>false,'error'=>$err]); exit;
}
$ins->close();

echo json_encode(['ok'=>true,'uid'=>$uid,'referralCode'=>$myRef]);
