<?php
require __DIR__.'/config.php'; json();
$in = json_decode(file_get_contents('php://input'), true) ?? [];
$missing = required($in,['email','captchaNonce','captchaAnswer','captchaEcho']);
if ($missing){ echo json_encode(['ok'=>false,'error'=>'MISSING_'.$missing]); exit; }

$email = strtolower(trim($in['email']));
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) { echo json_encode(['ok'=>false,'error'=>'INVALID_EMAIL']); exit; }

$echo = json_decode(base64_decode($in['captchaEcho']), true);
if (!$echo || !isset($echo['a'],$echo['b'])) { echo json_encode(['ok'=>false,'error'=>'CAPTCHA_TAMPERED']); exit; }
$correct = intval($echo['a']) + intval($echo['b']);
if (intval($in['captchaAnswer']) !== $correct){ echo json_encode(['ok'=>false,'error'=>'CAPTCHA_FAIL']); exit; }

$otp = rand_code(6);
$nonce = preg_replace('/[^a-f0-9]/i','', $in['captchaNonce']);
$exp = (new DateTime('+10 minutes'))->format('Y-m-d H:i:s');

$conn = db();
$stmt = $conn->prepare("INSERT INTO pending_otps (email, otp_code, captcha_nonce, captcha_answer, expires_at)
VALUES (?,?,?,?,?)
ON DUPLICATE KEY UPDATE otp_code=VALUES(otp_code), captcha_nonce=VALUES(captcha_nonce), captcha_answer=VALUES(captcha_answer), expires_at=VALUES(expires_at)");
$ans = $correct;
$stmt->bind_param('sssis',$email,$otp,$nonce,$ans,$exp);
$stmt->execute(); $stmt->close();

$sent = send_mail($email,'Your Quantum OTP',"<p>Your OTP is <b>$otp</b>. It expires in 10 minutes.</p>");
if(!$sent){ echo json_encode(['ok'=>false,'error'=>'MAIL_FAIL']); exit; }

echo json_encode(['ok'=>true,'sent'=>true]);
