<?php
declare(strict_types=1);

/* ===== Defaults ===== */
date_default_timezone_set('UTC');

/* ===== MySQL (Heliohost) ===== */
define('DB_HOST', 'localhost');
define('DB_USER', 'rokinyt55_2ndquantum');
define('DB_PASS', 'Quantum06+Faiza9');
define('DB_NAME', 'rokinyt55_2ndquantum');
define('DB_PORT', 3306);

/* ===== Site ===== */
define('SITE_EMAIL', 'noreply@quantumapp.heliohost.us');
define('SITE_NAME',  'Quantum');

/* ===== CORS (FINAL) ===== */
$origin = $_SERVER['HTTP_ORIGIN'] ?? '*';
header('Access-Control-Allow-Origin: ' . $origin);
header('Vary: Origin');
header('Access-Control-Allow-Credentials: true');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Auth-Token, X-Requested-With');
header('Access-Control-Expose-Headers: Content-Type, Content-Length');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

/* ===== JSON helpers ===== */
function json(): void { header('Content-Type: application/json; charset=utf-8'); }
function json_ok($data): void { json(); echo json_encode(['ok'=>true,'data'=>$data], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }
function json_fail(string $msg, int $code=200, $detail=null): void {
  http_response_code($code); json();
  $out=['ok'=>false,'error'=>$msg]; if($detail!==null)$out['detail']=(string)$detail;
  echo json_encode($out, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit;
}

/* ===== DB (exception-safe) ===== */
function db(): mysqli {
  static $c=null; if($c instanceof mysqli) return $c;
  mysqli_report(MYSQLI_REPORT_ERROR|MYSQLI_REPORT_STRICT);
  try { $c=new mysqli(DB_HOST,DB_USER,DB_PASS,DB_NAME,DB_PORT); $c->set_charset('utf8mb4'); }
  catch(Throwable $e){ json_fail('DB_CONNECT_FAIL',200,$e->getMessage()); }
  return $c;
}

/* ===== Request helpers ===== */
function body_json(): array {
  $raw=file_get_contents('php://input')?:''; if($raw!==''){ $j=json_decode($raw,true); if(is_array($j)) return $j; }
  return $_POST?:[];
}
function required(array $a, array $keys): ?string { foreach($keys as $k){ if(!isset($a[$k])||$a[$k]==='') return $k; } return null; }

/* ===== Casts ===== */
function to_int($v,$d=0): int { if(is_numeric($v)) return (int)$v; $f=filter_var($v,FILTER_VALIDATE_INT); return $f===false?(int)$d:(int)$f; }
function to_float($v,$d=0.0): float { if(is_numeric($v)) return (float)$v; return (float)$d; }

/* ===== HTTP JSON (Binance etc.) ===== */
function fetch_json(string $url,int $timeout=12): array {
  if(function_exists('curl_init')){
    $ch=curl_init($url);
    curl_setopt_array($ch,[CURLOPT_RETURNTRANSFER=>true,CURLOPT_FOLLOWLOCATION=>true,
      CURLOPT_CONNECTTIMEOUT=>8,CURLOPT_TIMEOUT=>$timeout,
      CURLOPT_SSL_VERIFYPEER=>true,CURLOPT_SSL_VERIFYHOST=>2,
      CURLOPT_USERAGENT=>'Quantum-API/1.0']);
    $raw=curl_exec($ch); if($raw===false){$e=curl_error($ch);curl_close($ch);throw new Exception('CURL_FAIL: '.$e);}
    $code=curl_getinfo($ch,CURLINFO_HTTP_CODE); curl_close($ch);
    if($code!==200) throw new Exception('HTTP_'.$code);
    $dec=json_decode($raw,true); if(!is_array($dec)) throw new Exception('JSON_DECODE_FAIL'); return $dec;
  }
  $ctx=stream_context_create(['http'=>['method'=>'GET','timeout'=>$timeout,'header'=>"User-Agent: Quantum-API/1.0\r\n"],'ssl'=>['verify_peer'=>true,'verify_peer_name'=>true]]);
  $raw=@file_get_contents($url,false,$ctx); if($raw===false) throw new Exception('HTTP_FAIL_FOPEN');
  $dec=json_decode($raw,true); if(!is_array($dec)) throw new Exception('JSON_DECODE_FAIL'); return $dec;
}

/* ===== UID/Referral utils ===== */
function gen_uid6(): string { return (string)random_int(100000,999999); }
function make_uid_unique(mysqli $db,int $tries=12): ?string {
  for($i=0;$i<$tries;$i++){ $u=gen_uid6(); $q=$db->prepare("SELECT uid FROM users WHERE uid=? LIMIT 1");
    $q->bind_param('s',$u); $q->execute(); $q->store_result(); if($q->num_rows===0){$q->close(); return $u;} $q->close(); }
  return null;
}
function gen_ref6(): string { $a='ABCDEFGHJKLMNPQRSTUVWXYZ23456789'; $s=''; for($i=0;$i<3;$i++) $s.=$a[random_int(0,strlen($a)-1)]; return 'QTX'.$s; }
function make_ref_unique(mysqli $db,int $tries=12): ?string {
  for($i=0;$i<$tries;$i++){ $r=gen_ref6(); $q=$db->prepare("SELECT referral_code FROM users WHERE referral_code=? LIMIT 1");
    $q->bind_param('s',$r); $q->execute(); $q->store_result(); if($q->num_rows===0){$q->close(); return $r;} $q->close(); }
  return null;
}

/* ===== Mail (optional) ===== */
function send_mail(string $to,string $sub,string $html): bool {
  $h="MIME-Version: 1.0\r\nContent-type: text/html; charset=utf-8\r\nFrom: ".SITE_NAME." <".SITE_EMAIL.">\r\n";
  return @mail($to,$sub,$html,$h);
}
