<?php
require __DIR__.'/config.php'; json();

$in = json_decode(file_get_contents('php://input'), true) ?? [];
$id = trim($in['id'] ?? '');
$pass = (string)($in['password'] ?? '');

if ($id === '') { echo json_encode(['ok'=>false,'error'=>'MISSING_ID']); exit; }
if ($pass === '') { echo json_encode(['ok'=>false,'error'=>'MISSING_PASSWORD']); exit; }

$conn = db();

// pick by email or phone
if (filter_var($id, FILTER_VALIDATE_EMAIL)) {
  $q = $conn->prepare("SELECT uid,email,password_hash,referral_code FROM users WHERE email=? LIMIT 1");
} else {
  $q = $conn->prepare("SELECT uid,email,password_hash,referral_code FROM users WHERE phone=? LIMIT 1");
}
$q->bind_param('s', $id);
$q->execute();
$res = $q->get_result();
$row = $res ? $res->fetch_assoc() : null;
$q->close();

// user not found
if (!$row) {
  echo json_encode(['ok'=>false,'error'=>'USER_NOT_FOUND']); exit;
}

// wrong password
if (!password_verify($pass, $row['password_hash'])) {
  echo json_encode(['ok'=>false,'error'=>'WRONG_PASSWORD']); exit;
}

// success
$token = bin2hex(random_bytes(24));
echo json_encode([
  'ok'   => true,
  'token'=> $token,
  'user' => [
    'uid'          => $row['uid'],
    'email'        => $row['email'],
    'referralCode' => $row['referral_code']
  ]
]);
