<?php
// summary.php — returns { total_assets_usdt, pnl_1d, notifications }
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Methods: GET, OPTIONS");
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(200); exit; }

require_once __DIR__ . '/config.php';

try {
  // ensure table
  $conn->query("CREATE TABLE IF NOT EXISTS user_wallets (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    total_assets_usdt DECIMAL(18,8) NOT NULL DEFAULT 0,
    pnl_1d DECIMAL(18,8) NOT NULL DEFAULT 0,
    updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY uniq_user (user_id)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

  $userId = 1; // TODO: bind with your auth token later

  // seed if missing
  $stmt = $conn->prepare("SELECT total_assets_usdt, pnl_1d FROM user_wallets WHERE user_id=? LIMIT 1");
  $stmt->bind_param('i', $userId);
  $stmt->execute();
  $res = $stmt->get_result();
  if ($res->num_rows === 0) {
    $seedAssets = 0.00;
    $seedPnl    = 0.00;
    $ins = $conn->prepare("INSERT INTO user_wallets (user_id, total_assets_usdt, pnl_1d) VALUES (?, ?, ?)");
    $ins->bind_param('idd', $userId, $seedAssets, $seedPnl);
    $ins->execute();
    $res = $stmt->get_result(); // re-run not needed; will fetch again below
    $stmt->execute();
    $res = $stmt->get_result();
  }
  $row = $res->fetch_assoc();

  json_ok([
    'total_assets_usdt' => (float)$row['total_assets_usdt'],
    'pnl_1d'            => (float)$row['pnl_1d'],
    'notifications'     => 0,
  ]);
} catch (Throwable $e) {
  json_fail('SUMMARY_ERROR: '.$e->getMessage(), 200); // 200 so app still shows 0.00
}
