<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type');

$host    = 'localhost';
$db      = 'rokinyt55_signal';
$user    = 'rokinyt55_signal';
$pass    = 'Elon@0653';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success'=>false,'message'=>'DB failed','error'=>$e->getMessage()]);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
if (!is_array($input)) $input = $_POST;

$id       = (int)($input['id'] ?? 0);
$isActive = isset($input['is_active']) ? (int)$input['is_active'] : null;

if ($id <= 0 || $isActive === null) {
    echo json_encode(['success'=>false,'message'=>'id and is_active required']);
    exit;
}

try {
    $stmt = $pdo->prepare('UPDATE markets SET is_active = :a WHERE id = :id LIMIT 1');
    $stmt->execute([':a'=>$isActive, ':id'=>$id]);

    echo json_encode(['success'=>true,'message'=>'Status updated']);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success'=>false,'message'=>'Update failed','error'=>$e->getMessage()]);
}
