<?php
require_once __DIR__ . '/../../config/db.php';
require_once __DIR__ . '/../../config/helpers.php';

$input = read_input();
require_fields(['memo_key'], $input);
$memo = trim((string)$input['memo_key']);
if ($memo === '' || strlen($memo) < 6) {
    json_response(['success'=>false,'message'=>'Invalid memo_key'], 400);
}

$pdo->prepare("INSERT INTO app_settings (setting_key, setting_value) VALUES ('memo_key', ?) ON DUPLICATE KEY UPDATE setting_value=VALUES(setting_value)")->execute([$memo]);
json_response(['success'=>true,'message'=>'Updated', 'data'=>['memo_key'=>$memo]]);
