<?php
require_once __DIR__ . '/../../config/db.php';
require_once __DIR__ . '/../../config/helpers.php';

$status = isset($_GET['status']) ? strtolower(trim((string)$_GET['status'])) : '';
// allowed: pending, approved, rejected, none
if ($status !== '' && !in_array($status, ['pending','approved','rejected','none'], true)) {
    json_response(['success'=>false,'message'=>'Invalid status'], 400);
}

$sql = "SELECT a.user_id, a.api_status, a.trade_unlocked, a.signal_unlocked, a.memo_verified, a.created_at, a.updated_at,
               u.name, u.email, u.role
        FROM user_trade_access a
        JOIN users u ON u.id = a.user_id";
$params = [];
if ($status !== '') {
    $sql .= " WHERE a.api_status = :s";
    $params[':s'] = $status;
}
$sql .= " ORDER BY a.updated_at DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

json_response(['success'=>true,'data'=>$rows]);
