<?php
require_once __DIR__ . '/../../config/db.php';
require_once __DIR__ . '/../../config/helpers.php';
require_once __DIR__ . '/../../lib/crypto.php';

$userId = isset($_GET['user_id']) ? (int)$_GET['user_id'] : 0;
if ($userId <= 0) json_response(['success'=>false,'message'=>'user_id required'], 400);
$mask = isset($_GET['mask']) ? (int)$_GET['mask'] : 1;

$stmt = $pdo->prepare("SELECT user_id, api_status, api_key_enc, api_secret_enc, updated_at FROM user_trade_access WHERE user_id=? LIMIT 1");
$stmt->execute([$userId]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$row) json_response(['success'=>false,'message'=>'Not found'], 404);

$apiKey = decrypt_text((string)($row['api_key_enc'] ?? ''));
$apiSecret = decrypt_text((string)($row['api_secret_enc'] ?? ''));

function mask_str(string $s): string {
    $len = strlen($s);
    if ($len <= 6) return str_repeat('*', $len);
    return substr($s, 0, 3) . str_repeat('*', max(0, $len - 6)) . substr($s, -3);
}

if ($mask === 1) {
    $apiKey = mask_str($apiKey);
    $apiSecret = mask_str($apiSecret);
}

json_response([
    'success'=>true,
    'data'=>[
        'user_id'=>$userId,
        'api_status'=>$row['api_status'],
        'api_key'=>$apiKey,
        'api_secret'=>$apiSecret,
        'updated_at'=>$row['updated_at'],
    ],
]);
