<?php
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../config/helpers.php';

$input = read_input();
require_fields(['email', 'password'], $input);

$email    = trim($input['email']);
$password = $input['password'];

try {
    $stmt = $pdo->prepare(
        "SELECT id, name, email, password_hash, role
         FROM users WHERE email = :email LIMIT 1"
    );
    $stmt->execute([":email" => $email]);
    $user = $stmt->fetch();

    if (!$user || !password_verify($password, $user['password_hash'])) {
        json_response([
            "success" => false,
            "message" => "Invalid email or password"
        ], 401);
    }

    // simple random token (future e JWT use korte paro)
    $token = bin2hex(random_bytes(24));

    json_response([
        "success" => true,
        "message" => "Login success",
        "data"    => [
            "id"    => (int)$user['id'],
            "name"  => $user['name'],
            "email" => $user['email'],
            "role"  => $user['role'], // 'admin' or 'user'
            "token" => $token,
        ]
    ]);
} catch (PDOException $e) {
    json_response([
        "success" => false,
        "message" => "Database error",
        "error"   => $e->getMessage()
    ], 500);
}
