<?php
// config/helpers.php

// ------------- CORS SETUP (for Flutter Web) -------------
$allowedOrigins = [
    'http://localhost:5000',
    'http://localhost:63500',
    'http://localhost:3000',
    'http://127.0.0.1:5500',
    'http://127.0.0.1:8080',
    'https://quantumapp.heliohost.us',
];

// Origin thakle check kore allow kori, na thakle * use
if (isset($_SERVER['HTTP_ORIGIN']) && in_array($_SERVER['HTTP_ORIGIN'], $allowedOrigins)) {
    header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
} else {
    header("Access-Control-Allow-Origin: *");
}

header('Access-Control-Allow-Credentials: true');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');

// Preflight (OPTIONS) request hole ekhanei end
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}
// ------------- END CORS SETUP ---------------------------

function json_response($data, int $statusCode = 200) {
    http_response_code($statusCode);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($data);
    exit;
}

// required fields validation
function require_fields(array $fields, array $source) {
    foreach ($fields as $f) {
        if (!isset($source[$f]) || trim((string)$source[$f]) === '') {
            json_response([
                "success" => false,
                "message" => "Missing field: $f"
            ], 400);
        }
    }
}

// unify JSON / form input
function read_input() {
    $input = $_POST;

    if (empty($input)) {
        $raw = file_get_contents('php://input');
        if ($raw) {
            $decoded = json_decode($raw, true);
            if (is_array($decoded)) {
                $input = $decoded;
            }
        }
    }

    return $input;
}
