<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type');

// ==== DB CONNECTION ====
$host    = 'localhost';
$db      = 'rokinyt55_signal';
$user    = 'rokinyt55_signal';
$pass    = 'Elon@0653';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database connection failed',
        'error'   => $e->getMessage(),
    ]);
    exit;
}

$type = isset($_GET['type']) ? $_GET['type'] : 'perpetual';

// ------ ছোট একটা helper: Bybit থেকে ticker map আনা ------
function fetchBybitTickersLinear() {
    $url = 'https://api.bybit.com/v5/market/tickers?category=linear';

    if (!function_exists('curl_init')) {
        return [
            'ok'    => false,
            'error' => 'cURL not available on server',
            'map'   => []
        ];
    }

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT        => 8,
    ]);

    $body     = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $err      = curl_error($ch);
    curl_close($ch);

    if ($body === false || $httpCode !== 200) {
        return [
            'ok'    => false,
            'error' => "http=$httpCode; curl_error=$err",
            'map'   => []
        ];
    }

    $json = json_decode($body, true);
    if (!isset($json['result']['list']) || !is_array($json['result']['list'])) {
        return [
            'ok'    => false,
            'error' => 'unexpected json from bybit',
            'map'   => []
        ];
    }

    $map = [];
    foreach ($json['result']['list'] as $t) {
        $symbol = $t['symbol'] ?? null;
        if (!$symbol) continue;
        $map[$symbol] = $t;
    }

    return [
        'ok'    => true,
        'error' => '',
        'map'   => $map,
    ];
}

// ----- main -----
try {
    $stmt = $pdo->prepare(
        'SELECT id, symbol, base_asset, quote_asset, type
         FROM markets
         WHERE is_active = 1 AND type = :type
         ORDER BY sort_order ASC, id ASC'
    );
    $stmt->execute([':type' => $type]);
    $rows = $stmt->fetchAll();

    if (!$rows) {
        echo json_encode([
            'success' => true,
            'markets' => [],
            'bybit_ok' => false,
            'bybit_error' => 'no rows in markets table',
        ]);
        exit;
    }

    // Bybit tickers
    $tickersResult = fetchBybitTickersLinear();
    $tickerMap     = $tickersResult['map'];
    $bybitOk       = $tickersResult['ok'];
    $bybitError    = $tickersResult['error'];

    // Common coin icons (Coingecko CDN – usually CORS OK)
    $iconMap = [
        'BTC' => 'https://assets.coingecko.com/coins/images/1/small/bitcoin.png',
        'ETH' => 'https://assets.coingecko.com/coins/images/279/small/ethereum.png',
        'SOL' => 'https://assets.coingecko.com/coins/images/4128/small/solana.png',
        'XRP' => 'https://assets.coingecko.com/coins/images/44/small/xrp-symbol-white-128.png',
        'DOGE'=> 'https://assets.coingecko.com/coins/images/5/small/dogecoin.png',
        'ADA' => 'https://assets.coingecko.com/coins/images/975/small/cardano.png',
        'BNB' => 'https://assets.coingecko.com/coins/images/825/small/binance-coin-logo.png',
        'DOT' => 'https://assets.coingecko.com/coins/images/12171/small/polkadot.png',
        'MNT' => 'https://assets.coingecko.com/coins/images/31069/small/coin-round-black.png',
    ];

    $out = [];

    foreach ($rows as $r) {
        $symbol   = $r['symbol'];
        $base     = $r['base_asset'];
        $quote    = $r['quote_asset'];

        $t = isset($tickerMap[$symbol]) ? $tickerMap[$symbol] : null;

        $lastPrice = 0.0;
        $changePct = 0.0;
        $vol       = 0.0;

        if ($t) {
            // lastPrice
            if (isset($t['lastPrice'])) {
                $lastPrice = (double)$t['lastPrice'];
            }

            // price24hPcnt is decimal (0.0123 => 1.23%)
            if (isset($t['price24hPcnt'])) {
                $changePct = (double)$t['price24hPcnt'] * 100.0;
            }

            if (isset($t['turnover24h'])) {
                $vol = (double)$t['turnover24h'];
            }
        }

        $baseUpper = strtoupper($base);
        $iconUrl   = isset($iconMap[$baseUpper]) ? $iconMap[$baseUpper] : '';

        $out[] = [
            'id'          => (int)$r['id'],
            'symbol'      => $symbol,
            'base'        => $base,
            'quote'       => $quote,
            'type'        => $r['type'],
            'last_price'  => $lastPrice,
            'change_24h'  => $changePct,
            'volume_24h'  => $vol,
            'icon_url'    => $iconUrl,
        ];
    }

    echo json_encode([
        'success'     => true,
        'markets'     => $out,
        'source'      => 'bybit_v5_linear',
        'bybit_ok'    => $bybitOk,
        'bybit_error' => $bybitError,
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Query failed',
        'error'   => $e->getMessage(),
    ]);
}
