<?php
require_once __DIR__ . '/../config/helpers.php';

// Default symbols jodi client kichu na dey
$defaultSymbols = ['BTCUSDT', 'ETHUSDT', 'SOLUSDT', 'MNTUSDT', 'XRPUSDT'];

$symbols = $defaultSymbols;

// GET ?symbols=BTCUSDT,ETHUSDT type dile override
if (isset($_GET['symbols']) && trim($_GET['symbols']) !== '') {
    $parts = explode(',', $_GET['symbols']);
    $clean = [];
    foreach ($parts as $p) {
        $s = strtoupper(trim($p));
        if ($s !== '') {
            $clean[] = $s;
        }
    }
    if (!empty($clean)) {
        $symbols = $clean;
    }
}

$binanceUrl = 'https://api.binance.com/api/v3/ticker/24hr?symbols=' .
    urlencode(json_encode($symbols));

function fetch_from_binance($url) {
    if (function_exists('curl_init')) {
        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CONNECTTIMEOUT => 6,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_SSL_VERIFYPEER => true,
        ]);
        $result = curl_exec($ch);
        $err = curl_error($ch);
        $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($result === false || $status !== 200) {
            return [null, $err ?: "HTTP $status"];
        }
        return [$result, null];
    } else {
        $context = stream_context_create([
            'http' => [
                'timeout' => 10,
            ],
        ]);
        $result = @file_get_contents($url, false, $context);
        if ($result === false) {
            return [null, 'file_get_contents failed'];
        }
        return [$result, null];
    }
}

list($raw, $error) = fetch_from_binance($binanceUrl);

if ($error !== null || $raw === null) {
    json_response([
        'success' => false,
        'message' => 'Failed to fetch from Binance',
        'error'   => $error,
    ], 502);
}

$data = json_decode($raw, true);
if (!is_array($data)) {
    json_response([
        'success' => false,
        'message' => 'Invalid response from Binance',
    ], 502);
}

// Just forward important fields
$mapped = [];
foreach ($data as $item) {
    $mapped[] = [
        'symbol'              => $item['symbol'] ?? '',
        'lastPrice'           => $item['lastPrice'] ?? '0',
        'priceChangePercent'  => $item['priceChangePercent'] ?? '0',
        'quoteVolume'         => $item['quoteVolume'] ?? '0',
    ];
}

json_response([
    'success' => true,
    'data'    => $mapped,
]);
