-- Run this ONCE on your MySQL database

CREATE TABLE IF NOT EXISTS app_settings (
  setting_key VARCHAR(64) PRIMARY KEY,
  setting_value TEXT NOT NULL,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO app_settings (setting_key, setting_value)
VALUES ('memo_key','WHALESKITRU19992025')
ON DUPLICATE KEY UPDATE setting_value=VALUES(setting_value);

CREATE TABLE IF NOT EXISTS user_trade_access (
  user_id INT PRIMARY KEY,
  trade_unlocked TINYINT(1) NOT NULL DEFAULT 0,
  signal_unlocked TINYINT(1) NOT NULL DEFAULT 0,

  api_status ENUM('none','pending','approved','rejected') NOT NULL DEFAULT 'none',
  api_key_enc TEXT NULL,
  api_secret_enc TEXT NULL,

  memo_verified TINYINT(1) NOT NULL DEFAULT 0,

  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,

  CONSTRAINT fk_user_trade_access_user FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Optional index (run once, ignore if already exists)
-- CREATE INDEX idx_user_trade_access_api_status ON user_trade_access (api_status);
