<?php
require_once __DIR__ . '/_trade_helpers.php';

$input = read_input();
$userId = trade_resolve_user_id($pdo, $input);

$row = trade_ensure_access_row($pdo, $userId);

json_response([
    'success' => true,
    'data' => [
        'user_id' => $userId,
        'trade_unlocked' => ((int)($row['trade_unlocked'] ?? 0) === 1),
        'api_status' => (string)($row['api_status'] ?? 'none'),
        'memo_verified' => ((int)($row['memo_verified'] ?? 0) === 1),
        'has_api' => (trim((string)($row['api_key_enc'] ?? '')) !== '' && trim((string)($row['api_secret_enc'] ?? '')) !== ''),
    ],
]);
