<?php
require_once __DIR__ . '/_trade_helpers.php';

$input = read_input();
$userId = trade_resolve_user_id($pdo, $input);
$keys = trade_require_api_approved($pdo, $userId);

$symbol = isset($input['symbol']) ? strtoupper(trim((string)$input['symbol'])) : '';
$settleCoin = isset($input['settleCoin']) ? strtoupper(trim((string)$input['settleCoin'])) : 'USDT';
$body = ['category'=>'linear'];
if ($symbol !== '') $body['symbol'] = $symbol; else $body['settleCoin'] = $settleCoin;

$res = bybit_private_post('/v5/order/cancel-all', $body, $keys['api_key'], $keys['api_secret']);
if (!$res['ok'] || !$res['body_json']) {
    json_response(['success'=>false,'message'=>'Bybit request failed','error'=>$res['error'],'http'=>$res['http']], 502);
}
$resp = $res['body_json'];
if (!isset($resp['retCode']) || (int)$resp['retCode'] !== 0) {
    json_response(['success'=>false,'message'=>'Bybit error','retCode'=>$resp['retCode']??null,'retMsg'=>$resp['retMsg']??null,'raw'=>$resp], 502);
}
json_response(['success'=>true,'data'=>$resp]);
