<?php
require_once __DIR__ . '/_trade_helpers.php';

$input = read_input();
require_fields(['symbol'], $input);
$userId = trade_resolve_user_id($pdo, $input);
$keys = trade_require_api_approved($pdo, $userId);

$symbol = strtoupper(trim((string)$input['symbol']));
$orderId = isset($input['orderId']) ? trim((string)$input['orderId']) : '';
$orderLinkId = isset($input['orderLinkId']) ? trim((string)$input['orderLinkId']) : '';

if ($orderId === '' && $orderLinkId === '') {
    json_response(['success'=>false,'message'=>'orderId or orderLinkId required'], 400);
}

$body = ['category'=>'linear','symbol'=>$symbol];
if ($orderId !== '') $body['orderId'] = $orderId;
if ($orderLinkId !== '') $body['orderLinkId'] = $orderLinkId;

$res = bybit_private_post('/v5/order/cancel', $body, $keys['api_key'], $keys['api_secret']);
if (!$res['ok'] || !$res['body_json']) {
    json_response(['success'=>false,'message'=>'Bybit request failed','error'=>$res['error'],'http'=>$res['http']], 502);
}
$resp = $res['body_json'];
if (!isset($resp['retCode']) || (int)$resp['retCode'] !== 0) {
    json_response(['success'=>false,'message'=>'Bybit error','retCode'=>$resp['retCode']??null,'retMsg'=>$resp['retMsg']??null,'raw'=>$resp], 502);
}
json_response(['success'=>true,'data'=>$resp]);
