<?php
require_once __DIR__ . '/_trade_helpers.php';

$input = read_input();
require_fields(['symbol'], $input);
$userId = trade_resolve_user_id($pdo, $input);
$keys = trade_require_api_approved($pdo, $userId);

$symbol = strtoupper(trim((string)$input['symbol']));
$positionIdx = isset($input['positionIdx']) && is_numeric($input['positionIdx']) ? (int)$input['positionIdx'] : 0;

$tp = isset($input['takeProfit']) ? trim((string)$input['takeProfit']) : '';
$sl = isset($input['stopLoss']) ? trim((string)$input['stopLoss']) : '';

if ($tp === '' && $sl === '') {
    json_response(['success'=>false,'message'=>'takeProfit or stopLoss required'], 400);
}

$body = [
    'category' => 'linear',
    'symbol' => $symbol,
    'positionIdx' => $positionIdx,
    'tpslMode' => 'Full',
];
if ($tp !== '') $body['takeProfit'] = $tp;
if ($sl !== '') $body['stopLoss'] = $sl;

$body['tpTriggerBy'] = isset($input['tpTriggerBy']) ? (string)$input['tpTriggerBy'] : 'LastPrice';
$body['slTriggerBy'] = isset($input['slTriggerBy']) ? (string)$input['slTriggerBy'] : 'LastPrice';

$res = bybit_private_post('/v5/position/trading-stop', $body, $keys['api_key'], $keys['api_secret']);
if (!$res['ok'] || !$res['body_json']) {
    json_response(['success'=>false,'message'=>'Bybit request failed','error'=>$res['error'],'http'=>$res['http']], 502);
}
$jb = $res['body_json'];
if (!isset($jb['retCode']) || (int)$jb['retCode'] !== 0) {
    json_response(['success'=>false,'message'=>'Bybit error','retCode'=>$jb['retCode']??null,'retMsg'=>$jb['retMsg']??null,'raw'=>$jb], 502);
}

json_response(['success'=>true,'data'=>$jb]);
