<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type');

// ==== DB CONNECTION ====
$host    = 'localhost';
$db      = 'rokinyt55_signal';
$user    = 'rokinyt55_signal';
$pass    = 'Elon@0653';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";

$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database connection failed',
        'error'   => $e->getMessage(),
    ]);
    exit;
}

// ==== READ INPUT ====
$input = json_decode(file_get_contents('php://input'), true);
if (!is_array($input)) {
    $input = $_POST;
}

$id    = isset($input['id']) ? (int)$input['id'] : null;
$email = isset($input['email']) ? trim($input['email']) : null;

if (empty($id) && empty($email)) {
    echo json_encode([
        'success' => false,
        'message' => 'id or email required',
    ]);
    exit;
}

// ফিল্ডগুলো optional
$newName      = isset($input['name']) ? trim($input['name']) : null;
$newEmail     = isset($input['new_email']) ? trim($input['new_email']) : null;
$newAvatar    = isset($input['avatar']) ? trim($input['avatar']) : null;
$currentPass  = isset($input['current_password']) ? $input['current_password'] : null;
$newPassword  = isset($input['new_password']) ? $input['new_password'] : null;

try {
    // ---- User লোড ----
    if (!empty($id)) {
        $stmt = $pdo->prepare('SELECT * FROM users WHERE id = :id LIMIT 1');
        $stmt->execute([':id' => $id]);
    } else {
        $stmt = $pdo->prepare('SELECT * FROM users WHERE email = :email LIMIT 1');
        $stmt->execute([':email' => $email]);
    }

    $user = $stmt->fetch();
    if (!$user) {
        echo json_encode([
            'success' => false,
            'message' => 'User not found',
        ]);
        exit;
    }

    $updates = [];
    $params  = [];

    if ($newName !== null && $newName !== '' && $newName !== $user['name']) {
        $updates[]        = 'name = :name';
        $params[':name']  = $newName;
    }

    if ($newEmail !== null && $newEmail !== '' && $newEmail !== $user['email']) {
        $updates[]           = 'email = :email';
        $params[':email']    = $newEmail;
    }

    if ($newAvatar !== null && $newAvatar !== '' && in_array($newAvatar, ['male','female','whale'])) {
        $updates[]            = 'avatar = :avatar';
        $params[':avatar']    = $newAvatar;
    }

    // Password change (optional)
    if ($currentPass !== null && $newPassword !== null && $newPassword !== '') {
        if (!password_verify($currentPass, $user['password_hash'])) {
            echo json_encode([
                'success' => false,
                'message' => 'Current password is incorrect',
            ]);
            exit;
        }

        $hash = password_hash($newPassword, PASSWORD_DEFAULT);
        $updates[]                  = 'password_hash = :password_hash';
        $params[':password_hash']   = $hash;
    }

    if (empty($updates)) {
        echo json_encode([
            'success' => false,
            'message' => 'Nothing to update',
        ]);
        exit;
    }

    $whereClause = '';
    if (!empty($id)) {
        $whereClause      = 'id = :uid';
        $params[':uid']   = $id;
    } else {
        $whereClause      = 'email = :uemail';
        $params[':uemail']= $email;
    }

    $sql = 'UPDATE users SET ' . implode(', ', $updates) . ' WHERE ' . $whereClause . ' LIMIT 1';
    $updateStmt = $pdo->prepare($sql);
    $updateStmt->execute($params);

    echo json_encode([
        'success' => true,
        'message' => 'Profile updated successfully',
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Update failed',
        'error'   => $e->getMessage(),
    ]);
}
