<?php
// api/wallet/get_withdraw_info.php
ini_set('display_errors', 0);
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type');

require_once __DIR__ . '/../db.php';

try {
    $pdo = getDb();
} catch (Throwable $e) {
    echo json_encode(['success' => false, 'message' => 'DB connection failed']);
    exit;
}

$input  = json_decode(file_get_contents('php://input'), true);
$email  = isset($input['email']) ? trim($input['email']) : '';
$symbol = 'USDT';

if ($email === '') {
    echo json_encode(['success' => false, 'message' => 'Email required']);
    exit;
}

try {
    // ensure table exists
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS wallet_balances (
          id INT AUTO_INCREMENT PRIMARY KEY,
          user_id INT NOT NULL,
          account_type ENUM('funding','unified') NOT NULL,
          symbol VARCHAR(16) NOT NULL,
          amount DECIMAL(32,8) NOT NULL DEFAULT 0,
          UNIQUE KEY unique_balance (user_id, account_type, symbol)
        )
    ");

    $stmt = $pdo->prepare('SELECT id FROM users WHERE email = ? LIMIT 1');
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        echo json_encode(['success' => false, 'message' => 'User not found']);
        exit;
    }
    $userId = (int) $user['id'];

    $stmt = $pdo->prepare("
        SELECT amount FROM wallet_balances
        WHERE user_id = ? AND account_type = 'funding' AND symbol = 'USDT'
        LIMIT 1
    ");
    $stmt->execute([$userId]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    $funding = $row ? (float) $row['amount'] : 0.0;

    $stmt = $pdo->prepare("
        SELECT amount FROM wallet_balances
        WHERE user_id = ? AND account_type = 'unified' AND symbol = 'USDT'
        LIMIT 1
    ");
    $stmt->execute([$userId]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    $unified = $row ? (float) $row['amount'] : 0.0;

    $fee       = 1.5;
    $minAmount = 2.6;

    echo json_encode([
        'success' => true,
        'data'    => [
            'symbol'     => 'USDT',
            'network'    => 'TRC20',
            'fee'        => $fee,
            'min_amount' => $minAmount,
            'funding'    => $funding,
            'unified'    => $unified,
            'total'      => $funding + $unified,
        ],
    ]);

} catch (Throwable $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Server error in get_withdraw_info',
    ]);
}
