<?php
// api/wallet/get_withdrawable_coins.php

// IMPORTANT: একদম শুরুতেই PHP tag, এর আগে কোন স্পেস / নিউলাইন থাকবে না
ini_set('display_errors', 0);
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type');

// তোমার আগের ফাইল যেখানে getDb() আছে (যেটা profile.php তে include করো)
// সেটার নাম ধরলাম db.php
require_once __DIR__ . '/../db.php';

try {
    $pdo = getDb();
} catch (Throwable $e) {
    echo json_encode([
        'success' => false,
        'message' => 'DB connection failed',
    ]);
    exit;
}

// ---- ইনপুট ----
$raw = file_get_contents('php://input');
$input = json_decode($raw, true);
$email = isset($input['email']) ? trim($input['email']) : '';

if ($email === '') {
    echo json_encode([
        'success' => false,
        'message' => 'Email required',
    ]);
    exit;
}

try {
    // wallet_balances টেবিল না থাকলে অটো create করে নাও
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS wallet_balances (
          id INT AUTO_INCREMENT PRIMARY KEY,
          user_id INT NOT NULL,
          account_type ENUM('funding','unified') NOT NULL,
          symbol VARCHAR(16) NOT NULL,
          amount DECIMAL(32,8) NOT NULL DEFAULT 0,
          UNIQUE KEY unique_balance (user_id, account_type, symbol)
        )
    ");

    // user
    $stmt = $pdo->prepare('SELECT id FROM users WHERE email = ? LIMIT 1');
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        echo json_encode([
            'success' => false,
            'message' => 'User not found',
        ]);
        exit;
    }

    $userId = (int) $user['id'];

    // FUNDING + UNIFIED মিলিয়ে মোট USDT
    $stmt = $pdo->prepare("
        SELECT SUM(amount) AS total_amount
        FROM wallet_balances
        WHERE user_id = ? AND symbol = 'USDT'
    ");
    $stmt->execute([$userId]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    $totalAmount = $row && $row['total_amount'] !== null
        ? (float) $row['total_amount']
        : 0.0;

    $coins = [];

    if ($totalAmount > 0) {
        $coins[] = [
            'symbol'      => 'USDT',
            'name'        => 'Tether USDT',
            'icon'        => 'https://assets.coingecko.com/coins/images/325/large/Tether-logo.png',
            'amount'      => $totalAmount,
            'amount_usd'  => $totalAmount, // 1 USDT ≈ 1 USD
        ];
    }

    echo json_encode([
        'success' => true,
        'coins'   => $coins,
    ]);

} catch (Throwable $e) {
    // কোন error হলেই এখানে pure JSON রেসপন্স যাবে, HTML না
    echo json_encode([
        'success' => false,
        'message' => 'Server error in get_withdrawable_coins',
    ]);
}
