<?php
require_once __DIR__.'/config.php';
require_once __DIR__.'/auth.php';

$u = require_user();
$in = $_GET ?: input_json();
$symbol  = strtoupper(trim((string)($in['symbol'] ?? 'USDT')));
$network = strtoupper(trim((string)($in['network'] ?? 'TRC20')));

if ($symbol === '' || $network === '') json_error('symbol and network required', 422);

$seed = hash('sha256', $u['user_id'].'|'.$symbol.'|'.$network);
$demo = substr(strtoupper($seed), 0, 34);

if ($network === 'TRC20') {
  $addr = 'T'.substr($demo, 0, 33);
} elseif ($network === 'ERC20') {
  $addr = '0x'.substr(strtolower($seed), 0, 40);
} elseif ($network === 'BTC') {
  $addr = 'bc1q'.substr(strtolower($seed), 0, 38);
} else {
  $addr = $demo;
}

json_ok(['symbol' => $symbol, 'network' => $network, 'address' => $addr, 'note' => 'Demo address for UI testing only']);
