<?php
require __DIR__.'/config.php';

db()->exec("
CREATE TABLE IF NOT EXISTS users (
  id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  email VARCHAR(190) UNIQUE,
  phone VARCHAR(64) UNIQUE,
  passhash VARCHAR(255) NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS api_tokens (
  id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  user_id INT UNSIGNED NOT NULL,
  token CHAR(64) NOT NULL UNIQUE,
  expires_at DATETIME NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  INDEX (user_id),
  CONSTRAINT fk_tok_user FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS tickers (
  id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  symbol VARCHAR(32) NOT NULL,
  price DECIMAL(18,8) NOT NULL,
  change24h DECIMAL(8,2) NOT NULL DEFAULT 0,
  volume_usd DECIMAL(24,2) NOT NULL DEFAULT 0,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY uniq_symbol (symbol)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");

db()->exec("
INSERT INTO tickers(symbol, price, change24h, volume_usd) VALUES
 ('BTC/USDT', 64850,  1.20, 25000000000),
 ('ETH/USDT', 2650,  -0.80, 12200000000),
 ('SOL/USDT',  188,  2.40,  4500000000),
 ('XRP/USDT', 0.58,  0.60,  1100000000),
 ('DOGE/USDT',0.124,-1.30,   950000000),
 ('ADA/USDT', 0.41,  0.20,   600000000),
 ('BNB/USDT',  598,  0.90,  3100000000)
ON DUPLICATE KEY UPDATE price=VALUES(price), change24h=VALUES(change24h), volume_usd=VALUES(volume_usd);
");

json_ok(['message' => 'Installation/seed complete']);
