<?php
require_once __DIR__.'/config.php';
require_once __DIR__.'/auth.php';

$in = $_POST ?: input_json();
$id   = trim((string)($in['id'] ?? ''));
$pass = (string)($in['password'] ?? '');

if ($id === '' || $pass === '') json_error('Missing credentials', 422);

$q = db()->prepare('SELECT id, passhash, email, phone FROM users WHERE (email = ? OR phone = ?) LIMIT 1');
$q->execute([$id, $id]);
$u = $q->fetch();
if (!$u) json_error('User not found', 404);

if (!password_verify($pass, $u['passhash'])) json_error('Invalid password', 401);

$token = issue_token((int)$u['id']);
json_ok([
  'token' => $token,
  'user'  => [ 'id' => (int)$u['id'], 'email' => $u['email'], 'phone' => $u['phone'] ]
]);
