<?php
require_once __DIR__.'/config.php';

$in = $_POST ?: input_json();
$email = trim((string)($in['email'] ?? ''));
$phone = trim((string)($in['phone'] ?? ''));
$pass  = (string)($in['password'] ?? '');

if (($email === '' && $phone === '') || $pass === '') {
  json_error('Provide email or phone and password', 422);
}

if ($email !== '') {
  $q = db()->prepare('SELECT id FROM users WHERE email=?');
  $q->execute([$email]);
  if ($q->fetch()) json_error('Email already registered', 409);
}
if ($phone !== '') {
  $q = db()->prepare('SELECT id FROM users WHERE phone=?');
  $q->execute([$phone]);
  if ($q->fetch()) json_error('Phone already registered', 409);
}

$hash = password_hash($pass, PASSWORD_DEFAULT);
$q = db()->prepare('INSERT INTO users(email, phone, passhash) VALUES(?,?,?)');
$q->execute([$email ?: null, $phone ?: null, $hash]);

json_ok(['user_id' => (int)db()->lastInsertId()]);
