<?php
// zip_download.php — HelioHost all files downloader
$rootPath = realpath(__DIR__);

// Name of the zip
$zipFile = __DIR__ . '/site_backup.zip';

// Initialize archive
$zip = new ZipArchive();
$zip->open($zipFile, ZipArchive::CREATE | ZipArchive::OVERWRITE);

// Create recursive directory iterator
$files = new RecursiveIteratorIterator(
    new RecursiveDirectoryIterator($rootPath, RecursiveDirectoryIterator::SKIP_DOTS),
    RecursiveIteratorIterator::SELF_FIRST
);

foreach ($files as $file) {
    $filePath = realpath($file);
    if (strpos($filePath, $zipFile) !== false) continue; // skip own zip
    $relativePath = substr($filePath, strlen($rootPath) + 1);
    if (!$file->isDir()) {
        $zip->addFile($filePath, $relativePath);
    }
}
$zip->close();

// Send file to browser
header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="site_backup.zip"');
header('Content-Length: ' . filesize($zipFile));
readfile($zipFile);
unlink($zipFile);
exit;